//
//  Image.m
//  POSSDKForIOS 2013-07-25
//
//  Created by liangchenying on 12-4-10.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Image.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface Image()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation Image
@synthesize Back;
@synthesize ImageName;
@synthesize ModeButton;
@synthesize ImageWidth;
@synthesize ImagePrintButton;
@synthesize Cut;

@synthesize pos_sdk		    = _pos_sdk;

@synthesize array_Mode	    = _array_Mode;
@synthesize selectedMode	= _selectedMode;

- (NSMutableArray*)array_Mode
{
    if(_array_Mode  == nil)
    {
        _array_Mode = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_Mode;
}

- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
        //**************************************************************************************************
        //Add object for array_Mode
        [self.array_Mode addObject:@"8Dot Single Density"];
        [self.array_Mode addObject:@"8Dot Double Density"];
        [self.array_Mode addObject:@"24Dot Single Density"];
        [self.array_Mode addObject:@"24Dot Double Density"]; 
    }

    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    self.selectedMode = 0;

    [self.ImageName  setDelegate:self];
    [self.ImageWidth setDelegate:self];
    
    [self.ModeButton setTitle:@"8Dot Single Density" forState:UIControlStateNormal];
    
    [self.ImageName  setText:@"SAMPLE.bmp"];
    [self.ImageWidth setText:@"500"];
}

- (void)viewDidUnload
{
    [self setBack:nil];
    [self setImageName:nil];
    [self setModeButton:nil];
    [self setImageWidth:nil];
    [self setImagePrintButton:nil];
    [self setCut:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Exit the keyboard by clicking "return"
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
       [self.ImageName  resignFirstResponder];
       [self.ImageWidth resignFirstResponder];
       return NO;
    } 
    return YES;
}

//**************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender 
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

//**************************************************************************************************
//Select Mode(8Dot Single Density\8Dot Double Density\24Dot Single Density\24Dot Double Density) Index
- (IBAction)selectMode:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedMode = selectedIndex;    
        [self.ModeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Mode" Sheet:self.array_Mode Selected:self.selectedMode DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Print Image
- (IBAction)ImagePrint:(id)sender 
{
    SInt32   error_code  = SUCCESS;
    SInt32   width       = 0; 
    SInt32   i           = 0;
    SInt32   mode        = 0;
    NSString *image_name = nil;
   
	NSString *full_path  = nil;
	UIImage  *image      = nil;
    
	image_name = self.ImageName.text;
    full_path  = [[[NSBundle mainBundle] bundlePath] stringByAppendingPathComponent:image_name];
    image      = [[UIImage alloc] initWithContentsOfFile:full_path];
    
    JudgeParamNil(ImageName, @"Image Name == nil , please Input image name.");
    
    if (image == nil) 
    {
        AlertViewShow(@"Image is not exist,please check image name.");
        goto ExitLine;
    }
    
    //**********************************************************************************************
	//Printer width cannot be nil,
    JudgeParamNil(ImageWidth, @"PrinterWidth == nil,Please input Printer Width");
    
    //**********************************************************************************************
	//Judge printer width must be digits
    JudgeParamDigitOrNot(ImageWidth, @"ERROR Printer width! It must be  0  or 64-65535.");
    
    //**********************************************************************************************
	//Printer width must be 0 or 64-65535
    width = [self.ImageWidth.text intValue];
//    JudgePrinterWidthRange(width, @"ERROR Printer width! It must be  0  or 64-65535.",65535);

    if(self.selectedMode == 0)          mode = SingleDensity_8;
    else if(self.selectedMode == 1)     mode = DoubleDensity_8;
    else if(self.selectedMode == 2)     mode = SingleDensity_24;
    else if(self.selectedMode == 3)     mode = DoubleDensity_24;
    
    //**************************************************************************************************
    //Print image in standard mode
    error_code = [self.pos_sdk  imageStandardModePrint:mode Image:image StartHorPos:0 PrinterWidth:width];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
	error_code = [self.pos_sdk systemReset];   
ExitLine: 
    [image release];
    return;   
}

- (IBAction)Cut:(id)sender 
{
    SInt32 error_code = SUCCESS;
    
   error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:80];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }

ExitLine:
    return;
}

- (void)dealloc
{
    [self.Back release];
    [self.ImageName release];
    [self.ModeButton release];
    [self.ImageWidth release];
    [self.ImagePrintButton release];
    [self.array_Mode release];
    [self.Cut release];
    [super dealloc];
}

@end
